package w83b.w83bUtilidades;

import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Iterator;

import org.apache.commons.lang.StringUtils;
/**
 * 
 * @author 
 *
 */
public abstract class W83bUtilidadesRTF{
	

	  /**
	   * Lee el fichero dado y lo devuelve en una secuencia de caracteres
	   * 
	 * @param filename - el fichero a convertir
	 * @return
	 * @throws IOException
	 */
	public static CharSequence leerTodoFichero(String filename) throws IOException
	  {
	    CharBuffer cbuf = null;

	      FileInputStream fis = new FileInputStream(W83bUtilidadesRTF.class.getResource(filename).getPath());
	      FileChannel fc = fis.getChannel();
	      ByteBuffer bbuf = fc.map(FileChannel.MapMode.READ_ONLY, 0L, 
	        (int)fc.size());
	      cbuf = Charset.forName("8859_1").newDecoder()
	        .decode(bbuf);

	    return cbuf;
	  }
	
	
	/**
	 * Lee el fichero dado y lo devuelve en una secuencia de caracteres
	 * 
	 * @param filename - el fichero a convertir
	 * @return
	 * @throws IOException
	 */
	public static CharSequence leerTodoFichero(byte[] file) throws IOException{
		String fileStr = new String(file);
		
		int posUltLlave = fileStr.lastIndexOf("}");
		
		if(posUltLlave != fileStr.length()-1){
			fileStr = fileStr.substring(0,posUltLlave+1);
		}
		
		return fileStr;
	}
	  
	  /**
	   * Coge un fichero dado y sustituye las palabras que se indican en la clave del hashmap por el value del mismo.
	   * Devuelve un StringBuffer con el fichero pero con los valores sustituidos
	   * 
	 * @param filename - fichero a sustituir sus palabras
	 * @param mapaPares - {["palabra a sustituir1","palabra que sustituye1"],["palabra a sustituir2","palabra que sustituye2"],...}
	 * @return
	 * @throws IOException
	 */
	public static StringBuffer sustituirCadenaCaracteresRtf(String filename,HashMap mapaPares) throws IOException{
		    StringBuffer contenido = new StringBuffer();
		    contenido.append(leerTodoFichero(filename).toString());
		    
		    String contenidoStr = contenido.toString().replaceAll("\r", "").replaceAll("\n","");
		    contenido = new StringBuffer(contenidoStr);
		    
		    
		    Iterator itmapaPares = mapaPares.keySet().iterator();
		    
		    //En una primera vuelta se sustituyen todas las variables del hashmap tal cual
		    while(itmapaPares.hasNext()){
		    	String key = (String)itmapaPares.next();
		    	contenido = new StringBuffer(contenido.toString().replaceAll(key, (String)mapaPares.get(key)));//NOPMD
		    }

		    
		    return contenido;
	  }
	
	/**
	 * Coge un fichero dado y sustituye las palabras que se indican en la clave del hashmap por el value del mismo.
	 * Devuelve un StringBuffer con el fichero pero con los valores sustituidos
	 * 
	 * @param filename - fichero a sustituir sus palabras
	 * @param mapaPares - {["palabra a sustituir1","palabra que sustituye1"],["palabra a sustituir2","palabra que sustituye2"],...}
	 * @return
	 * @throws IOException
	 */
	public static StringBuffer sustituirCadenaCaracteresRtf(byte[] file,HashMap mapaPares) throws IOException{
		StringBuffer contenido = new StringBuffer();
		contenido.append(leerTodoFichero(file).toString());
		
		String contenidoStr = contenido.toString().replaceAll("\r", "").replaceAll("\n","");
		contenido = new StringBuffer(contenidoStr);
		
		
		Iterator itmapaPares = mapaPares.keySet().iterator();
		
		//En una primera vuelta se sustituyen todas las variables del hashmap tal cual
		while(itmapaPares.hasNext()){
			String key = (String)itmapaPares.next();
			String value = (String)mapaPares.get(key);
			if(StringUtils.isEmpty(value)){
				value = "";
			}
			contenido = new StringBuffer(contenido.toString().replaceAll(key, value));//NOPMD
		}
		
//		    String palabraClave = "";
//		    boolean parseandoKey = false;
		
		//Al pasar a texto plano el fichero hay veces que se cortan las claves en el documento, para
		//evitar esto se va a mirar si en la 1 vuelta ha quedado alguna clave sin cambiar, 
		//en ese caso se proceder a cambiarlas parseando el texto caracter a caracter desde la primera cadena "<<" 
//		    if(-1!=contenido.indexOf("<<")){
//		    	while(-1!=contenido.indexOf("<<")){
//		    		char actual = contenido.toString().toCharArray()[contenido.indexOf("<<")];
//		    		int i = contenido.indexOf("<<");
//		    		parseandoKey = true;
//		    		palabraClave = String.valueOf(actual);
//		    		i++;
//		    		while(parseandoKey){
//		    			actual = contenido.toString().toCharArray()[i];
//			    		palabraClave = palabraClave + String.valueOf(actual);
//			    		if('>'==contenido.toString().toCharArray()[i]
//			    		      &&'>'==contenido.toString().toCharArray()[i-1]){
//			    			parseandoKey = false;
//			    			contenido = new StringBuffer(contenido.toString().replaceAll(palabraClave, (String)mapaPares.get(palabraClave.replaceAll("\r", "").replaceAll("\n",""))));
//			    		}
//			    		i++;
//		    		}		    		
//		    	}
//		    }
		
		return contenido;
	}
	
	  /**
	   * Coge un fichero dado y sustituye las palabras que se indican en la clave del hashmap por el value del mismo.
	   * Devuelve un StringBuffer con el fichero pero con los valores sustituidos
	   * 
	 * @param filename - fichero a sustituir sus palabras
	 * @param mapaPares - {["palabra a sustituir1","palabra que sustituye1"],["palabra a sustituir2","palabra que sustituye2"],...}
	 * @return
	 * @throws IOException
	 */
	public static StringBuffer sustituirCadenaCaracteresString(StringBuffer contenido,HashMap mapaPares) throws IOException{
		   
			StringBuffer retorno=contenido;
		    String contenidoStr = retorno.toString().replaceAll("\r", "").replaceAll("\n","");
		    retorno = new StringBuffer(contenidoStr);
		    
		    
		    Iterator itmapaPares = mapaPares.keySet().iterator();
		    
		    //En una primera vuelta se sustituyen todas las variables del hashmap tal cual
		    while(itmapaPares.hasNext()){
		    	String key = (String)itmapaPares.next();
		    	retorno = new StringBuffer(retorno.toString().replaceAll(key, (String)mapaPares.get(key)));//NOPMD
		    }
		    

		    
		    return retorno;
	  }
	public static String meterIntroCarpeta(String texto,int z, int limit)
	{
		 return meterIntro( texto, z,  limit,26);
	}
	public static String meterIntroEtiquetas(String texto,int z, int limit)
	{
		 return meterIntro( texto, z,  limit,30);
	}
	public static String meterIntro(String texto,int z, int limit,int ancho)
	{
		
		if(z==limit)
		{
			return "...";
		}else{
			
			
			if(texto.length()>ancho)
			{
				String comienzo=texto.substring(0,ancho);
				String separador="";
				int iVacio=comienzo.lastIndexOf(" ");
				int iGuion=comienzo.lastIndexOf("-");
				int iComa=comienzo.lastIndexOf(",");
				int iPunto=comienzo.lastIndexOf(".");
				int i=30;
				if(iVacio!=-1 && iVacio>iGuion && iVacio>iComa && iVacio>iPunto )
				{
					i=iVacio;
					separador="";
				}else if(iGuion!=-1 &&  iGuion>iComa && iGuion>iPunto)
				{
					i=iGuion;
					separador="-";
				}else if(iComa!=-1 && iComa>iPunto)	
				{
					i=iComa;
					separador=",";
				}else if(iPunto!=-1){
					i=iPunto;
					separador=".";
				}
				
				return texto.substring(0,i)+separador+"\\\\line "+meterIntro(texto.substring(i+1, texto.length()),z+1,limit,ancho);
			}
			return texto;
			
		}
		
	}
	public static int numIntros(String texto)
	{
		String tex=texto;
		int num=0;
		int i=tex.indexOf("\\\\line");
		while(i!=-1)
		{
			num++;
			tex=tex.substring(i+1,tex.length());
			i=tex.indexOf("\\\\line");
		}
		return num;
		
	}
	
	public static String ponerBlancoANulo(String elemento){

		if (elemento==null){
			return "";
		}
		else{
			return elemento;
		}
		
	}	   
		
	
}


